/* -LICENSE-START-
** Copyright (c) 2011 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/

#ifndef BMD_STREAMING_DEVICE_INPUT_NOTIFIER_H__
#define BMD_STREAMING_DEVICE_INPUT_NOTIFIER_H__

#import "DeckLinkAPI.h"
#import "COMObject.h"

@protocol BMDStreamingDeviceInputDelegate
- (void)h264NALPacketArrived:(IBMDStreamingH264NALPacket*)packet;
- (void)h264AudioPacketArrived:(IBMDStreamingAudioPacket*)packet;
- (void)mpeg2TSPacketArrived:(IBMDStreamingMPEG2TSPacket*)packet;
- (void)h264VideoInputConnectorScanningChanged;
- (void)h264VideoInputConnectorChanged;
- (void)h264VideoInputModeChanged;
@end

extern const REFIID kIID_IBMDStreamingH264InputCallback;

class BMDStreamingDeviceInputNotifier : public COMObject<IBMDStreamingH264InputCallback,
                                                   &kIID_IBMDStreamingH264InputCallback>
{
public:
					BMDStreamingDeviceInputNotifier(id<BMDStreamingDeviceInputDelegate> delegate) : mDelegate(delegate) {}

	virtual SInt32	H264NALPacketArrived(IBMDStreamingH264NALPacket*);
	virtual SInt32	H264AudioPacketArrived(IBMDStreamingAudioPacket*);
	virtual SInt32	MPEG2TSPacketArrived(IBMDStreamingMPEG2TSPacket*);
    virtual SInt32	H264VideoInputConnectorScanningChanged();
    virtual SInt32	H264VideoInputConnectorChanged();
	virtual SInt32	H264VideoInputModeChanged();

private:
	virtual			~BMDStreamingDeviceInputNotifier() {}

	id<BMDStreamingDeviceInputDelegate> mDelegate;
};

#endif	// BMD_STREAMING_DEVICE_INPUT_NOTIFIER_H__
